//*******************************************************************************************************************************************
// Each instance of this class stores information about a single word.
//*******************************************************************************************************************************************

package ezreader10;

class Word {
    
    DV dv = new DV(); // initialize word DVs
    IV iv = new IV(); // initialize word IVs
    
    // Dependent variables:
    class DV {
        
        // Fixation-duration measures:
        double FFD = 0; // first-fixation duration (ms)
        double GD = 0; // gaze duration (ms)
        double GoPast = 0; // go-past time (ms)
        double SFD = 0; // single-fixation duration
        double TT = 0; // total time (ms)
        
        // Fixation-probability measures:
        double Pr1 = 0; // probability of making single fixation
        double Pr2 = 0; // probability of making 2+ fixations
        double PrF = 0; // probability of fixating word (during first or second pass)
        double PrS = 0; // probability of skipping word

        // Distributions:
        double distSFD[] = new double[EZReader10.maxLength]; // SFD distributions (i.e., IOVPs)
        double distPr1[] = new double[EZReader10.maxLength]; // Pr1 distributions (i.e., first-fixation landing sites)
        double distPr2[] = new double[EZReader10.maxLength]; // Pr2 distributions (i.e., refixation probabilities)    
        int NFirstPassFixations = 0; // number of first-pass fixations
        int NFixations = 0; // total number of fixations
        int NSFD[] = new int[EZReader10.maxLength]; // counters for SFD distributions
        
        int position1;
    }
    
    // Independent variables:
    class IV {
        double cloze; // cloze predictability
        int frequencyClass; // frequency class (1 = 1-10, 2 = 11-100, etc.)
        double frequency; // frequency count (per million)
        double length; // number of letters in word
        String letters; // word's spelling
        double log10Frequency; // = log10(frequency)
        int N; // number of word within sentence
        double OVP; // optimal-viewing position
        double position0; // cumulative number of the space preceding the word (i.e., leftmost edge of space)
        double position1; // cumulative number of first letter (i.e., leftmost edge of letter)
        double positionN; // cumulative number of last letter (i.e., rightmost edge of letter) 
    }
}

//*******************************************************************************************************************************************


